import os
import argparse
import shutil
import json
from nuscenes.nuscenes import NuScenes
from nuscenes.utils.splits import create_splits_scenes
def parse_arguments():
    parser = argparse.ArgumentParser(description='Export NuScenes video frames.')
    parser.add_argument('--version', type=str, choices=['trainval', 'test'], default='trainval', 
                        help='Specify the NuScenes version to use (train or test).')
    parser.add_argument('--nusc_root', type=str, default='/nuscenes')
    parser.add_argument('--sensors', type=str, nargs='+', default=['CAM_FRONT'], 
                        help='List of camera sensors to export (e.g., CAM_FRONT CAM_BACK).')
    parser.add_argument('--output_dir', type=str, default='dataset',
                        help='Directory to save exported video frames.')
    return parser.parse_args()
import pickle
from tqdm import tqdm
def main():
    args = parse_arguments()
    args.version = 'trainval'
    split = 'train'
    # Set NuScenes root directory
    nusc = NuScenes(version=f'v1.0-{args.version}', dataroot=args.nusc_root, verbose=True)

    # Load scene tokens
    scenes = create_splits_scenes()[split]
    scene_tokens = [s['token'] for s in nusc.scene if s['name'] in scenes]
    with open( f"nuscenes/data_nusc/nuscenes2d_ego_temporal_infos_{split}.pkl", 'rb') as f:
        data_anno = pickle.load(f)['infos']
    os.makedirs(args.output_dir, exist_ok=True)

    # Iterate over selected sensors
    for sensor in args.sensors:
        scene_imgs = {}
        for scene_token in tqdm(scene_tokens):
            scene = nusc.get('scene', scene_token)
            name = scene['name']
            # os.makedirs(os.path.join(args.output_dir, name), exist_ok=True)

            first_sample_token = scene['first_sample_token']
            last_sample_token = scene['last_sample_token']

            first_sample_rec = nusc.get('sample', first_sample_token)
            last_sample_rec = nusc.get('sample', last_sample_token)
            
            sample_token = first_sample_token
            # from first
            while sample_token != '':
                cur_sample = nusc.get('sample', sample_token)#go
                cru_token = cur_sample['data'][sensor]
                scene_imgs_next = []
                scene_imgs_prev = []
                frames = {}
                token = cru_token
                while len(scene_imgs_next) <= 24:#
                    data = nusc.get('sample_data', token)
                    scene_imgs_next.append(data['filename'])
                    if data["next"] == '':
                        break
                    else:
                        token = data["next"]
                token = cru_token
                while len(scene_imgs_prev) <= 24:#
                    data = nusc.get('sample_data', token)
                    scene_imgs_prev.append(data['filename'])
                    if data["prev"] == '':
                        break
                    else:
                        token = data["prev"]
                frames['prev'], frames['next'] = scene_imgs_prev[::-1], scene_imgs_next
                scene_imgs[cur_sample['token']] = frames
                sample_token = cur_sample['next']

            # Save scene_imgs as JSON
        output_json_path = os.path.join('dataset/nuscenes', f'{sensor}_{split}_imgs_path.json')
        with open(output_json_path, 'w') as json_file:
            json.dump(scene_imgs, json_file, indent=4)

        print(f"scene_imgs saved to {output_json_path}")

if __name__ == '__main__':
    main()
